#!/usr/bin/env python
# Select ID

# Copyright 2005 by Brian C. Christensen

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 050716 - first version of this script
# 050718 - more changes, now works

def hint(s):
    try:
        Data.Hint("%s: %s" % (scriptname, s))
    except AttributeError:
        self.SetStatusText(s)

def SelectID(self):
    rid = self.ReportID  # current report
    if rid == 1 :
        hint('Not for the main report')
        return  # do nothing

    # find cursor location
    selr = self.Report.GetGridCursorRow()  # current selection
    selc = self.Report.GetGridCursorCol()  # current selection

    # build short cuts to screen to data base xrefs
    cx = self.Report.table.columns
    # ox = self.Report.table.coloffset
    rx = self.Report.table.rows
    if not (cx and rx):
        hint("There are no cells to modify yet.")
        return

    colid = cx[selc]
    rowid = rx[selr]

    # build short cuts to data base tables
    dcol = Data.Database['ReportColumn']
    drow = Data.Database['ReportRow']
    dct = Data.Database['ColumnType']

    crec = dcol[colid]
    rrec = drow[rowid]

    # check column type for editable
    ctid = crec.get('ColumnTypeID')
    if not dct.has_key(ctid):
        hint("Error: Couldn't find the column type.")
        return

    ctrec = dct[ctid]

    editable = ctrec.get('Edit')  # column name???
    if not editable:
        hint('Only works with editable cells')
        return

    # make sure row table and column table match
    AorB = ctrec.get('T') or 'X'
    rtid = ctrec.get('ReportTypeID')
    coltable = Data.Database['ReportType'][rtid].get('Table' + AorB)
    rowtable = rrec.get('TableName')  # correct field?
    if rowtable != coltable:
        hint('Must be in cell that is active with this row.')
        return    

    # make sure this is an ID column
    colname = ctrec.get('Name')
    if not colname or colname[-2:] != 'ID' or colname == 'ID':
        hint('Only works with editable ID columns.')
        return

    # identify the table that contains the ids
    tablename = colname[:-2]
    if not Data.Database.has_key(tablename):
        hint("Couldn't find the table that contains the IDs (" + tablename + ").")
        return
    dtable = Data.Database[tablename]

    # make list of id's that could fit
    options = [ (dtable[x]['Name'], x) for x in dtable.keys() if dtable[x].get('zzStatus') != 'deleted' and dtable[x].has_key('Name') ]
    options.sort()

    # prompt user for selection
    menutext = [ x[0] for x in options ]
    dlg = wx.SingleChoiceDialog( self, 
                               "Select from these options:",
                               tablename, menutext)
    dlg.SetSize((240, 320))
    # dlg.Centre()
    if (dlg.ShowModal() != wx.ID_OK): return

    answer = dlg.GetSelection()  # returns an integer
    dlg.Destroy()

    resultid = options[answer][1]  # based on selection

    # set cell value to ID
    id = drow[rowid].get('TableID')  # correct field?
    change = { 'Table': rowtable, 'ID': id, colname: resultid }

    Data.Update(change)
    Data.SetUndo("Select ID")

SelectID(self)
